/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.registry;

import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.api.DashObject;
import dev.quantumfusion.dashloader.registry.chunk.write.AbstractWriteChunk;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public final class RegistryWriter {
    private final Object2IntOpenHashMap<?> dedup = new Object2IntOpenHashMap();
    private final Object2ByteMap<Class<?>> target2chunkMappings = new Object2ByteOpenHashMap();
    private final Object2ByteMap<Class<?>> dashTag2chunkMappings = new Object2ByteOpenHashMap();
    private final Object2ByteMap<Class<?>> mappings = new Object2ByteOpenHashMap();
    private final AbstractWriteChunk<?, ?>[] chunks;

    public RegistryWriter(AbstractWriteChunk<?, ?>[] chunks) {
        this.chunks = chunks;
    }

    public static int createPointer(int objectPos, byte chunkPos) {
        if (chunkPos > 63) {
            throw new IllegalStateException("Chunk pos is too big. " + chunkPos + " > 63");
        }
        if (objectPos > 0x3FFFFFF) {
            throw new IllegalStateException("Object pos is too big. " + objectPos + " > 67108863");
        }
        return objectPos << 6 | chunkPos & 0x3F;
    }

    void compileMappings() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (Class<?> aClass : this.chunks[i].getTargetClasses()) {
                this.mappings.put(aClass, (byte)i);
            }
        }
    }

    void addChunkMapping(Class<?> tag, byte pos) {
        this.dashTag2chunkMappings.put(tag, pos);
        DashObject declaredAnnotation = tag.getDeclaredAnnotation(DashObject.class);
        if (declaredAnnotation == null) {
            throw new RuntimeException("No DashObject annotation for " + tag.getSimpleName());
        }
        this.target2chunkMappings.put(declaredAnnotation.value(), pos);
    }

    public <R, D extends Dashable<R>> AbstractWriteChunk<R, D> getChunk(Class<D> dashType) {
        return this.chunks[this.dashTag2chunkMappings.getByte(dashType)];
    }

    public <R, D extends Dashable<R>> int addDirect(AbstractWriteChunk<R, D> chunk, R object) {
        int objectPos = chunk.add(object);
        int pointer = RegistryWriter.createPointer(objectPos, chunk.pos);
        this.dedup.put(object, pointer);
        return pointer;
    }

    public <R> int add(R object) {
        if (this.dedup.containsKey(object)) {
            return this.dedup.getInt(object);
        }
        Class<?> targetClass = object.getClass();
        byte chunkPos = this.mappings.getOrDefault(targetClass, (byte)-1);
        if (chunkPos == -1) {
            for (Object2ByteMap.Entry targetChunk : this.target2chunkMappings.object2ByteEntrySet()) {
                if (!((Class)targetChunk.getKey()).isAssignableFrom(targetClass)) continue;
                chunkPos = targetChunk.getByteValue();
                break;
            }
        }
        if (chunkPos == -1) {
            throw new RuntimeException("Could not find a ChunkWriter for " + targetClass);
        }
        AbstractWriteChunk<?, ?> chunk = this.chunks[chunkPos];
        int objectPos = chunk.add(object);
        int pointer = RegistryWriter.createPointer(objectPos, chunkPos);
        this.dedup.put(object, pointer);
        return pointer;
    }
}

